import type { Config } from 'tailwindcss';

const config: Config = {
  content: [
    './src/pages/**/*.{js,ts,jsx,tsx,mdx}',
    './src/components/**/*.{js,ts,jsx,tsx,mdx}',
    './src/pagesComponents/**/*.{js,ts,jsx,tsx,mdx}',
    './src/app/**/*.{js,ts,jsx,tsx,mdx}',
    './src/contexts/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {
      colors: {
        primary: '#2981B3',
        secondary: '#E3F6FE',
        text: '#18120F',
        background: '#F5F6FA',
        light_gray: '#E6E9EE',
        dark_gray: '#A6A6A6',
        navColor: '#011844',
        gradientDashboardTitles:
          'linear-gradient(45deg, #00D3EB 0%, #0083B8 100%);linear-gradient(45deg, color(display-p3 0.004 0.812 0.906) 0%, color(display-p3 0.161 0.506 0.702) 100%)',
      },
      backgroundImage: {
        'gradient-radial': 'radial-gradient(var(--tw-gradient-stops))',
        'gradient-conic': 'conic-gradient(from 180deg at 50% 50%, var(--tw-gradient-stops))',
        'gradient-dashboard-titles':
          'linear-gradient(45deg, #00D3EB 0%, #0083B8 100%);linear-gradient(45deg, color(display-p3 0.004 0.812 0.906) 0%, color(display-p3 0.161 0.506 0.702) 100%)',
        desktopBackgroundBlock: "url('/images/dashboard_dekstop_block_background.png')",
      },
      screens: {
        container: {
          max: '1820px',
        },
      },
    },
  },

  plugins: [],
};
export default config;
