import { $proxyapi, $api } from '@/api/api';

interface UserServiceResponse {
  result: 0;
  infos: {
    accountCategory: null;
    act: string;
    adminPermission: null;
    aesEncrypt: number;
    at: number;
    cps: null;
    ctm: number;
    depart: null;
    departmentEx: null;
    dis: number;
    driId: null;
    driver: null;
    email: null;
    id: number;
    identity: null;
    img: null;
    industry: null;
    isOnline: null;
    isSingleLogin: null;
    ism: null;
    lup: null;
    lv: null;
    maxLoginNumber: null;
    mtl: null;
    mtl2: null;
    muckDepartmentId: number;
    nm: string;
    openAutoAuthorize: null;
    phone: null;
    phoneEx: null;
    pid: number;
    pms: null;
    pnm: string;
    post: null;
    rid: null;
    rnm: null;
    role: null;
    roleStr: null;
    serverPermission: null;
    stu: number;
    userPosts: null;
    utm: number;
    vld: null;
    watermark: null;
    wxOpenid: null;
    wxUnionid: null;
  }[];
  pagination?: IPagination;
}

export const UserService = {
  getUsers() {
    return $proxyapi.post<UserServiceResponse>(
      'StandardUserAction_loadUsers.action?jsession=&type=1&nomalCancelQueryAuthorize=true',
    );
  },

  getOnlineUsersCount() {
    return $api.post(
      '808gps/OperationManagement/StandardUserAction_getOnlineClientCount.action?jsession=&',
    );
  },
};
