import { $proxyapi } from '@/api/api';
import { GeneralSettings } from '@/pagesComponents/Settings/types/GeneralSettings';

type GetTransportsResponse = GeneralSettings<
  {
    abbr: null;
    agent: null;
    area: null;
    artm: null;
    brand: null;
    btm: null;
    chnName: null;
    chnm: null;
    code: null;
    com: {
      id: string;
      name: string;
      parentId: number;
      level: number;
      companyId: number;
      companyName: string;
      linkMan: string;
    };
    cor: null;
    dateProduct: null;
    datePurchase: null;
    describe: null;
    devList: [
      {
        id: string;
        name: string;
        actualCardNumber: string;
        serialID: string;
        simInfo?: string;
      },
    ];
    dn: null;
    engineNum: null;
    frameNum: null;
    id: number;
    introduction: null;
    itm: string;
    itmDate: number;
    legal: null;
    legalAddress: null;
    legalPhone: null;
    lp: null;
    mrid: null;
    nuclearAuthority: null;
    ol: number;
    online: number;
    pst: null;
    ptp: number;
    pttm: null;
    serialNum: null;
    speedLimit: number;
    stm: string;
    stu: number;
    tcnm: null;
    tlNm: null;
    tm: string;
    tpst: null;
    userName: null;
    utm: string;
    vehicleModel: null;
    vehicleType: number;
    vid: string;
  }[]
>;

interface GetTransportByIdResponse {
  companyName: string;
  result?: 0;
  relations: {
    dr: null;
    id: number;
    ioInAttr: null;
    ioOutAttr: null;
    mainDev: number;
    module: number;
    ptt: null;
    standardVehiDevRelationEx: {
      chnAttr: string;
      devIdno: string;
      id: number;
      ioInAttr: null;
      ioOutAttr: null;
      mainDev: number;
      module: number;
      ptt: null;
      tempAttr: null;
      updateTime: null;
      vehiIdno: string;
    };
    tempAttr: null;
    updateTime: null;
    device: {
      accessLineWay: null;
      actualCardNumber: null;
      audioCodec: number;
      brand: null;
      cameraNumber: null;
      checkStatus: null;
      checkTime: null;
      chnName: null;
      cityId: null;
      communicationMode: null;
      devIDNO: string;
      devSubType: null;
      devType: number;
      deviceIdnos: null;
      diskType: null;
      company: {
        abbreviation: string;
        accountID: number;
        accountName: null;
        actName: null;
        address: string;
        area: string;
        businessLicenseNum: string;
        code: string;
        companyId: number;
        companyType: number;
        configuration: number;
        customerID: null;
        dispatchGroup: null;
        dispatcher: null;
        encryptPwd: null;
        function: null;
        gbCode: string;
        id: number;
        industryType: number;
        industryTypeStr: null;
        inspectAccount: null;
        inspectAccountStr: null;
        inspectReply: number;
        introduction: string;
        isAdd: null;
        isChild: null;
        isMine: null;
        legal: string;
        legalAddress: string;
        legalPhone: string;
        level: 1;
        linkEmail: string;
        linkMan: string;
        linkPhone: string;
        markerId: null;
        maxVehicleNum: null;
        monitor: string;
        monitorSupervisor: string;
        moreId: null;
        motorcade: false;
        motorcadeName: null;
        name: string;
        navImage: null;
        navTitle: null;
        nuclearAuthority: string;
        operatorCompanyId: null;
        operatorName: null;
        parentFunction: null;
        parentId: 1;
        parentName: null;
        password: null;
        platformId: null;
        quasiTransport: number;
        regionCode: null;
        regionId: null;
        regionName: null;
        registeredCapital: string;
        remark: string;
        strongPass: false;
        supervisorPhone: string;
        updateTime: number;
        validity: null;
        vehiAddDel: number;
        website: string;
      };
      extendedProtocol: number;
      faceProtocol: null;
      factory: null;
      factoryDevType: number;
      factoryType: number;
      gbCode: string;
      hardwareVer: null;
      id: number;
      idnobf: null;
      idnobg: null;
      ifMainDefense: number;
      imeiCode: null;
      inspectionDate: null;
      inspectionStandard: null;
      install: number;
      installDate: null;
      installationPlace: null;
      loginAccount: null;
      loginPwd: null;
      lstDeviceChn: null;
      macAddress: null;
      manufacturerId: null;
      model: null;
      netAddrType: null;
      nflt: null;
      parseGps: null;
      passWord: null;
      pickupNumber: null;
      positioningMode: null;
      productionDate: null;
      protocol: null;
      provinceId: null;
      ptt: null;
      remark: null;
      roadNetworkInfoParam: null;
      serialID: null;
      serverAddress: null;
      serverPort: null;
      simInfo: null;
      simMolectronCode: null;
      singleGpsDev: false;
      softwareVer: null;
      status: null;
      stlTm: number;
      storageMediumModel: null;
      storageMediumSize: null;
      storageMediumType: null;
      talkPhysicalChannel: null;
      transportEnterprise: null;
      updateTime: number;
      useStatus: number;
      vehiIdno: null;
    };
  }[];
  vehicle: {
    abbr: null;
    adasBrand: null;
    adasModel: null;
    agent: null;
    alarmTask: null;
    allowLogin: number;
    annualReviewDate: null;
    approvedLoad: null;
    approvedNumber: null;
    area: null;
    assessmentExpiration: null;
    axesNumber: null;
    blindBrand: null;
    blindModel: null;
    carBill: null;
    carPlace: null;
    carPrice: null;
    carType: null;
    chassisNum: null;
    chnCount: number;
    chnName: string;
    company: {
      abbreviation: string;
      accountID: number;
      accountName: null;
      actName: null;
      address: string;
      area: string;
      businessLicenseNum: string;
      code: string;
      companyId: number;
      companyType: number;
      configuration: number;
      customerID: null;
      dispatchGroup: null;
      dispatcher: null;
      encryptPwd: null;
      function: null;
      gbCode: string;
      id: number;
      industryType: number;
      industryTypeStr: null;
      inspectAccount: null;
      inspectAccountStr: null;
      inspectReply: number;
      introduction: string;
      isAdd: null;
      isChild: null;
      isMine: null;
      legal: string;
      legalAddress: string;
      legalPhone: string;
      level: number;
      linkEmail: string;
      linkMan: string;
      linkPhone: string;
      markerId: null;
      maxVehicleNum: null;
      monitor: string;
      monitorSupervisor: string;
      moreId: null;
      motorcade: false;
      motorcadeName: null;
      name: string;
      navImage: null;
      navTitle: null;
      nuclearAuthority: string;
      operatorCompanyId: null;
      operatorName: null;
      parentFunction: null;
      parentId: number;
      parentName: null;
      password: null;
      platformId: null;
      quasiTransport: number;
      regionCode: null;
      regionId: null;
      regionName: null;
      registeredCapital: string;
      remark: string;
      strongPass: false;
      supervisorPhone: string;
      updateTime: number;
      validity: null;
      vehiAddDel: number;
      website: string;
    };
    code: null;
    companyId: null;
    copyPass: false;
    customizeMenu: null;
    dateAnnualSurvey: null;
    dateProduct: null;
    datePurchase: null;
    devType: number;
    deviceIds: null;
    deviceInstallImgSrc: null;
    devices: null;
    driver: null;
    driver2: null;
    driverIds: null;
    driverList: [];
    driverUpdateTime: null;
    driverjobNums: null;
    drivingDate: null;
    drivingLicenseSrc: null;
    drivingNum: null;
    drivingNumImgUrl: null;
    drivingNumIueDate: null;
    drivingNumRegDate: null;
    dsmBrand: null;
    dsmModel: null;
    engineModel: null;
    engineNum: null;
    facialDevices: null;
    frameNum: null;
    freightVehicleType: null;
    gpsRetentionDay: null;
    highInsideDimensions: null;
    highOutlineDimensions: null;
    icon: number;
    id: number;
    idCardImageUrl: null;
    industry: null;
    installAdas: null;
    installBlind: null;
    installDsm: null;
    installLca: null;
    installOM: null;
    installPerson: null;
    installPersonPhone: null;
    installTire: null;
    introduction: null;
    ioInCount: null;
    ioInName: null;
    ioOutCount: null;
    ioOutName: null;
    jingDu: null;
    lcaBrand: null;
    lcaModel: null;
    legal: null;
    legalAddress: null;
    legalPhone: null;
    licenseExpiration: null;
    licenseReminderDays: null;
    lineId: null;
    linesOperation: null;
    linkPeople: null;
    linkPhone: null;
    loginPwd: null;
    longInsideDimension: null;
    longOutlineDimensions: null;
    mapType: null;
    mapValid: null;
    mileCoefficient: null;
    moreId: null;
    nuclearAuthority: null;
    oMBrand: null;
    oMModel: null;
    oldCompanyId: null;
    oldRelations: null;
    online: null;
    operatingDate: null;
    operatingId: null;
    operatingImgUrl: null;
    operatingLicenseSrc: null;
    operatingNum: null;
    operatorCompanyId: null;
    operatorName: null;
    ownerName: null;
    param1: null;
    param2: null;
    param3: null;
    param4: null;
    payBegin: number;
    payDelayDay: null;
    payEnable: null;
    payEnd: null;
    payMonth: null;
    perfectStatus: null;
    plateType: number;
    potInspectionDate: null;
    privilege: null;
    punchCard: null;
    quasiTractionMass: null;
    recordTask: null;
    relations: null;
    remark: '';
    repairDate: null;
    repairReminderDays: null;
    rid: null;
    rnm: null;
    roleId: null;
    safeDate: null;
    safeReminderDays: null;
    serialNum: null;
    simInfo: null;
    speedLimit: number;
    status: number;
    stlTm: number;
    stoDay: number;
    tempCount: null;
    tempName: null;
    timeEnd: null;
    tireBrand: null;
    tireModel: null;
    tm: null;
    totalWeight: null;
    trailerChassisNum: null;
    trailerDrivingDate: null;
    trailerDrivingLicenseSrc: null;
    trailerDrivingNum: null;
    trailerNum: null;
    trailerOperatingDate: null;
    trailerOperatingLicenseSrc: null;
    trailerOperatingNum: null;
    transportProof: null;
    transportReminderDays: null;
    transportStatus: null;
    transportVolume: null;
    travelReminderDays: null;
    updateTime: number;
    userName: null;
    vehiBand: null;
    vehiColor: null;
    vehiIDNO: string;
    vehiImgUrl: null;
    vehiType: null;
    vehiUse: null;
    vehicleAirConditioningSystem: null;
    vehicleAntilockBrakingSystem: null;
    vehicleBatteryType: null;
    vehicleBrakeForm: null;
    vehicleBusinessNature: null;
    vehicleChassis: null;
    vehicleClassLine: null;
    vehicleCurbWeight: null;
    vehicleDisplacement: null;
    vehicleDriveMotorModel: null;
    vehicleEmissionStandards: null;
    vehicleExpiryBusinessPeriod: null;
    vehicleFuelType: null;
    vehicleGrade: null;
    vehicleIds: null;
    vehicleInvoiceNumber: null;
    vehicleLineMileage: null;
    vehicleManufacturer: null;
    vehicleModel: null;
    vehicleMotorPower: null;
    vehicleNumber: null;
    vehicleOperatingLicense: null;
    vehicleOwner: null;
    vehiclePower: null;
    vehiclePowerType: null;
    vehicleRegistrationCertificateImageUrl: null;
    vehicleRegistrationDate: null;
    vehicleRegistrationNumber: null;
    vehicleRetarder: null;
    vehicleScrapDate: null;
    vehicleServiceBrakingMethod: null;
    vehicleSource: null;
    vehicleStopwatchMileage: null;
    vehicleTiresSpecification: null;
    vehicleTransfer: null;
    vehicleTransferOut: null;
    vehicleTransmissionForm: null;
    vehicleType: number;
    vehicleUse: null;
    vehicleWheelbase: null;
    weiDu: null;
    wideInnerDimensions: null;
    wideOutlineDimensions: null;
    wxOpenid: null;
  };
}

export const TransportService = {
  getTransports() {
    return $proxyapi.post<GetTransportsResponse>(
      'StandardVehicleAction_loadVehicles.action?jsession=&type=1&vehicleManager=true',
    );
  },

  getTransportById(id: string | number) {
    return $proxyapi.post<GetTransportByIdResponse>(
      `808gps/OperationManagement/StandardVehicleAction_findVehicle.action?jsession=&id=${id}&type=`,
    );
  },
};
