import { $proxyapi } from '@/api/api';
import type { GeneralSettings } from '@/pagesComponents/Settings/types/GeneralSettings';

type GetSimCardInfoResponse = GeneralSettings<
  {
    cardMerchant: null;
    cardNum: string;
    city: null;
    company: {
      abbreviation: string;
      accountID: 5;
      accountName: null;
      actName: null;
      address: string;
      area: string;
      businessLicenseNum: string;
      code: string;
      companyId: 1;
      companyType: 0;
      configuration: 2047;
      customerID: null;
      dispatchGroup: null;
      dispatcher: null;
      encryptPwd: null;
      function: null;
      gbCode: string;
      id: 4;
      industryType: 1;
      industryTypeStr: null;
      inspectAccount: null;
      inspectAccountStr: null;
      inspectReply: 0;
      introduction: string;
      isAdd: null;
      isChild: null;
      isMine: null;
      legal: string;
      legalAddress: string;
      legalPhone: string;
      level: 1;
      linkEmail: string;
      linkMan: string;
      linkPhone: string;
      markerId: null;
      maxVehicleNum: null;
      monitor: string;
      monitorSupervisor: string;
      moreId: null;
      motorcade: false;
      motorcadeName: null;
      name: string;
      navImage: null;
      navTitle: null;
      nuclearAuthority: string;
      operatorCompanyId: null;
      operatorName: null;
      parentFunction: null;
      parentId: number;
      parentName: null;
      password: null;
      platformId: null;
      quasiTransport: number;
      regionCode: null;
      regionId: null;
      regionName: null;
      registeredCapital: string;
      remark: string;
      strongPass: false;
      supervisorPhone: string;
      updateTime: number;
      validity: null;
      vehiAddDel: number;
      website: string;
    };
    companyID: number;
    companyName: string;
    devIDNO: string;
    devId: null;
    endTime: null;
    id: number;
    install: number;
    msisdn: null;
    oldDevId: null;
    operator: null;
    registrationTime: number;
    remark: null;
    simCard: null;
    status: number;
    updateTime: number;
    vehiIDNO: string;
  }[]
>;

export const SimCardService = {
  getSimCardInfo() {
    return $proxyapi.post<GetSimCardInfoResponse>(
      'StandardSIMCardInfoAction_loadSIMInfos.action?jsession=&type=1',
    );
  },
};
