import { GeneralSettings } from '@/pagesComponents/Settings/types/GeneralSettings';
import { $proxyapi } from '@/api/api';

type GetReminderAboutExpirstionTimeResponse = GeneralSettings<
  {
    assessmentExpiration: null;
    company: {
      abbreviation: string;
      accountID: number;
      accountName: null;
      actName: null;
      address: string;
      area: string;
      businessLicenseNum: string;
      code: string;
      companyId: number;
      companyType: number;
      configuration: number;
      customerID: null;
      dispatchGroup: null;
      dispatcher: null;
      encryptPwd: null;
      function: null;
      gbCode: string;
      id: number;
      industryType: number;
      industryTypeStr: null;
      inspectAccount: null;
      inspectAccountStr: null;
      inspectReply: number;
      introduction: string;
      isAdd: null;
      isChild: null;
      isMine: null;
      legal: string;
      legalAddress: string;
      legalPhone: string;
      level: number;
      linkEmail: string;
      linkMan: string;
      linkPhone: string;
      markerId: null;
      maxVehicleNum: null;
      monitor: string;
      monitorSupervisor: string;
      moreId: null;
      motorcade: false;
      motorcadeName: null;
      name: string;
      navImage: null;
      navTitle: null;
      nuclearAuthority: string;
      operatorCompanyId: null;
      operatorName: null;
      parentFunction: null;
      parentId: number;
      parentName: null;
      password: null;
      platformId: null;
      quasiTransport: number;
      regionCode: null;
      regionId: null;
      regionName: null;
      registeredCapital: string;
      remark: string;
      strongPass: false;
      supervisorPhone: string;
      updateTime: number;
      validity: null;
      vehiAddDel: number;
      website: string;
    };
    companyName: string;
    driving: string;
    linkPeople: null;
    linkPhone: null;
    onlineVehicleLicenseExpire: string;
    operating: string;
    plateType: number;
    repair: string;
    safe: string;
    service: string;
    sim: string;
    status: string;
    upkeepExpiredLicheng: string;
    upkeepExpiredTime: string;
    vehiIDNO: string;
    vehiId: number;
  }[]
>;

export const ReminderAboutExpirationTimeService = {
  getReminderAboutExpirationTime() {
    return $proxyapi.post<GetReminderAboutExpirstionTimeResponse>(
      'StandardVehicleAction_loadVehicleMaturitys.action?jsession=&type=1',
    );
  },
};
