import { $proxyapi } from '@/api/api';
import type { GeneralSettings } from '@/pagesComponents/Settings/types/GeneralSettings';

type GetDevicesService = GeneralSettings<
  {
    actualCardNumber: string;
    brand: null;
    checkStatus: null;
    checkTime: null;
    checkTimeStr: null;
    chnName: string;
    companyId: number;
    companyName: string;
    devIDNO: string;
    devType: number;
    factoryDevType: null;
    id: number;
    ifMainDefense: number;
    install: number;
    model: string;
    serialID: string;
    simInfo: string;
    stlTm: number;
    stlTmEx: null;
    stlTmExStr: null;
    stlTmStr: string;
    vehiIdno: string;
  }[]
>;

export const DeviceService = {
  getDevices() {
    return $proxyapi.post<GetDevicesService>(
      'StandardDeviceAction_loadDevices.action?jsession=&type=1&deviceManager=true',
    );
  },
};
