import { $proxyapi } from '@/api/api';
import type { GeneralSettings } from '@/pagesComponents/Settings/types/GeneralSettings';

type GetCompanyResponse = GeneralSettings<
  {
    abbreviation: string;
    accountID: number;
    accountName: string;
    actName: null;
    address: string;
    area: string;
    businessLicenseNum: string;
    code: string;
    companyId: number;
    companyType: number;
    configuration: number;
    customerID: null;
    dispatchGroup: null;
    dispatcher: null;
    encryptPwd: null;
    function: null;
    gbCode: string;
    id: number;
    industryType: number;
    industryTypeStr: null;
    inspectAccount: null;
    inspectAccountStr: null;
    inspectReply: number;
    introduction: string;
    isAdd: null;
    isChild: null;
    isMine: number;
    legal: string;
    legalAddress: string;
    legalPhone: string;
    level: number;
    linkEmail: string;
    linkMan: string;
    linkPhone: string;
    markerId: null;
    maxVehicleNum: null;
    monitor: string;
    monitorSupervisor: string;
    moreId: null;
    motorcade: false;
    motorcadeName: null;
    name: string;
    navImage: null;
    navTitle: null;
    nuclearAuthority: string;
    operatorCompanyId: null;
    operatorName: null;
    parentFunction: null;
    parentId: number;
    parentName: null;
    password: null;
    platformId: null;
    quasiTransport: number;
    regionCode: null;
    regionId: null;
    regionName: null;
    registeredCapital: string;
    remark: string;
    strongPass: false;
    supervisorPhone: string;
    updateTime: number;
    validity: null;
    vehiAddDel: number;
    website: string;
  }[]
>;

export const CompanyService = {
  getCompany() {
    return $proxyapi.post<GetCompanyResponse>(
      'StandardCompanyAction_loadUserCompanys.action?jsession=&type=1',
    );
  },
};
