import Icon from '@/components/Icon';

export const Videos = () => {
  return (
    <div>
      <div className='grid grid-cols-3 w-full' />
      <div className='border-[1px] border-light_gray px-[22px] py-5 bg-white rounded-[0px_0px_12px_12px]'>
        <div className='flex items-center'>
          <button title='Начать просмотр' arial-label='Начать просмотр' className='mr-[19px]'>
            <Icon src='/images/icons/icon-start-video.svg' className='w-6 h-6 text-primary' />
          </button>
          <button title='Пауза' arial-label='Пауза' className='mr-[19px]'>
            <Icon src='/images/icons/icon-pause-video.svg' className='w-6 h-6 text-[#D6D7DB]' />
          </button>
          <button title='Перемотать' arial-label='Перемотать' className='mr-[19px]'>
            <Icon src='/images/icons/icon-rewind.svg' className='w-6 h-6 text-[#D6D7DB]' />
          </button>

          <div className='flex items-center gap-[14px]'>
            <button>
              <Icon
                src='/images/icons/icon-minus-video-speed.svg'
                className='w-6 h-6 text-[#D6D7DB]'
              />
            </button>
            <p>1x</p>
            <button>
              <Icon
                src='/images/icons/icon-plus-video-speed.svg'
                className='w-6 h-6 text-[#D6D7DB]'
              />
            </button>
          </div>

          <div className='h-1 rounded-[3px] bg-[#0A0A0A0A] w-full mr-[27px] ml-[32px] after:w-[40%] after:bg-primary after:h-1 after:rounded-[3px] after:block' />

          <time className='text-text text-base'>00:00:00/00:00:00</time>
          <button title='open full' aria-label='open full' className='ml-7'>
            <Icon src='/images/full-screen.svg' className='w-6 h-6 text-primary' />
          </button>
        </div>
      </div>
    </div>
  );
};
