import { useRouter } from 'next/navigation';
import { type ReactNode, useEffect } from 'react';

interface Params {
  activeWidget: string;
  widgets: Record<string, { title: string; component: ReactNode }>;
  redirectLink: string;
}

/**
 * Хук, определяющий активный виджет и проверяющий есть ли такой виджет в принципе.
 * Если нет, то редиректит на главный виджет
 */
export const useDeterminateWidget = ({
  activeWidget,
  widgets,
  redirectLink,
}: Params): { widget: { title: string; component: ReactNode } } => {
  const router = useRouter();

  useEffect(() => {
    if (typeof activeWidget === 'string' && !widgets[activeWidget as keyof typeof widgets]) {
      router.push(redirectLink);
    }
  }, [activeWidget, router, widgets, redirectLink]);

  return {
    widget: widgets[activeWidget as keyof typeof widgets]
      ? widgets[activeWidget]
      : widgets[Object.keys(widgets)[0]],
  };
};
