import clsx from 'clsx';
import { FC, ReactNode } from 'react';
import { Container } from '@/components/UI/Container';

interface TableWrapperProps {
  children: ReactNode;
  className?: string;
}

const TableWrapper: FC<TableWrapperProps> = ({ children, className }) => {
  return (
    <div className={clsx('bg-white py-4', className)}>
      <Container>{children}</Container>
    </div>
  );
};

export default TableWrapper;
