interface Link {
  name: string;
  url: string;
  children?: Link[];
}

const STATISTICS_PAGE_PREFIX = '/statistics';

export const links: Link[] = [
  {
    name: 'Пробег',
    url: `${STATISTICS_PAGE_PREFIX}`,
    children: [
      { name: 'Суммарный пробег', url: '?widget=' },
      { name: 'Пробег День/Месяц отчет', url: '?widget=mileage_by_time' },
      { name: 'Ежемесячный пробег', url: '?widget=mileage_monthly' },
    ],
  },
  {
    name: 'Нарушение правил',
    url: `${STATISTICS_PAGE_PREFIX}/violation_rules`,
    children: [
      { name: 'Подробный отчёт', url: '?widget=' },
      { name: 'Количество нарушений', url: '?widget=numberOfViolations' },
      { name: 'Мониторинг пробега', url: '?widget=mileage_monitoring' },
      { name: 'Отчёт об устройстве', url: '?widget=device_report' },
    ],
  },
  {
    name: 'Остановки',
    url: `${STATISTICS_PAGE_PREFIX}/transport_stops`,
    children: [
      { name: 'Количество остановок', url: '?widget=' },
      { name: 'Остановки', url: '?widget=transportStops' },
      { name: 'Количество включений зажигания', url: '?widget=numberOfIgnitionSwitches' },
      { name: 'Подробный отчёт', url: '?widget=detailedReport' },
      { name: 'ACC ignition day statistics', url: '?widget=accIgnitionDayStatistics' },
    ],
  },
  {
    name: 'Порог превышения скорости',
    url: `${STATISTICS_PAGE_PREFIX}/threshold_speed_limit`,
    children: [
      { name: 'Порог превышения скорости', url: '?widget=' },
      { name: 'Сводный порог превышения скорости отчёт', url: '?widget=summarySpeedLimitReport' },
      { name: 'Идентификационная карта ID RPT', url: '?widget=idRptIdentificationCard' },
    ],
  },
  {
    name: 'Тревоги',
    url: `${STATISTICS_PAGE_PREFIX}/alarms`,
    children: [
      { name: 'Количество тревог', url: '?widget=' },
      { name: 'Ключевой тревожный запрос', url: '?widget=key_disturbing_request' },
      { name: 'Подробный отчёт', url: '?widget=detailed_report' },
    ],
  },
  {
    name: 'Мультимедиа',
    url: `${STATISTICS_PAGE_PREFIX}/multimedia`,
    children: [
      { name: 'Фото (новые)', url: '?widget=' },
      { name: 'Аудио (новые)', url: '?widget=audio' },
      { name: 'Видео (новые)', url: '?widget=video' },
    ],
  },
  {
    name: 'Запросы отчётов',
    url: `${STATISTICS_PAGE_PREFIX}/report_requests`,
    children: [
      { name: 'Запрошенные отчеты', url: '?widget=' },
      { name: 'Подробная выпущенная информация RPT', url: '?widget=detailed_info_rpt' },
      { name: 'Запись водителя RPT', url: '?widget=driver_info_rpt' },
      { name: 'Отчет о неисправностях', url: '?widget=faultReport' },
    ],
  },
  {
    name: 'Подключение к сети',
    url: `${STATISTICS_PAGE_PREFIX}/network_connecting`,
    children: [
      { name: 'Количество подключений и отключений', url: '?widget=' },
      { name: 'Подробный отчёт', url: '?widget=detailed_report' },
      { name: 'Журнал пользователя', url: '?widget=usersLog' },
      {
        name: 'Краткое описание действий пользователя',
        url: '?widget=shortDescriptionUserActions',
      },
      { name: 'Сведения о пользователе', url: '?widget=userInformation' },
      { name: 'User Media Summary', url: '?widget=userMediaSummary' },
      { name: 'Car Maintenance Records', url: '?widget=carMaintenanceRecords' },
      { name: 'Device Change RPT', url: '?widget=deviceChangeRpt' },
      { name: 'Mail Push Record', url: '?widget=mailPushRecord' },
    ],
  },
  {
    name: 'Геозоны',
    url: `${STATISTICS_PAGE_PREFIX}/geofences`,
    children: [
      { name: 'Общий отчет о геозонах', url: '?widget=' },
      { name: 'Подробный отчёт', url: '?widget=detailed_report' },
      {
        name: 'Подробная информация о зоне въезда и выезда',
        url: '?widget=detail_info_about_areas',
      },
    ],
  },
  {
    name: 'Топливо',
    url: `${STATISTICS_PAGE_PREFIX}/fuel`,
    children: [
      { name: 'Общий объем', url: '?widget=' },
      { name: 'Изменение объема', url: '?widget=volume_change' },
      {
        name: 'Тревоги датчика',
        url: '?widget=sensor_alarms',
      },
      { name: 'График расхода топлива', url: '?widget=fuel_consumption_chart' },
      { name: 'Расход топлива День/Месяц', url: '?widget=fuel_consumption_per_month_day' },
    ],
  },
  {
    name: 'Температура',
    url: `${STATISTICS_PAGE_PREFIX}/temperature`,
    children: [
      { name: 'Количество тревог', url: '?widget=' },
      { name: 'Изменение температуры', url: '?widget=temperature_change' },
      { name: 'Отчет о перегревах', url: '?widget=overheating_report' },
    ],
  },
  {
    name: 'Тревоги с датчика IO',
    url: `${STATISTICS_PAGE_PREFIX}/alarms_for_io_sensor`,
    children: [
      { name: 'Количество срабатываний', url: '?widget=' },
      { name: 'Подробный отчет', url: '?widget=detailed_report' },
    ],
  },
  {
    name: 'G-Сенсор отчёт',
    url: `${STATISTICS_PAGE_PREFIX}/g_sensor_report`,
    children: [
      { name: 'G-Сенсор тревога детально', url: '?widget=' },
      { name: 'Подробный отчет', url: '?widget=gSensorDetailReport' },
    ],
  },
  {
    name: 'Отчёт о статистике пассажирова',
    url: `${STATISTICS_PAGE_PREFIX}/passenger_statistics_report`,
    children: [
      { name: 'Детальная статистика пассажиров', url: '?widget=' },
      { name: 'Суммарная статистика пассажиров', url: '?widget=total_passenger_statistics' },
      { name: 'Сводная статистика пассажиров', url: '?widget=summary_passenger_statistics' },
      { name: 'Запрос статистики пассажиров', url: '?widget=request_for_passenger_statistics' },
    ],
  },
];
