import type { FC, ReactNode } from 'react';

interface StatisticsLayoutProps {
  title: string;
  children: ReactNode;
}

const StatisticsLayout: FC<StatisticsLayoutProps> = ({ children, title }) => {
  return (
    <section className='pb-10'>
      <h1 className='text-[#15223C] text-3xl text-[32px] font-medium my-6 max-w-[1820px] mx-auto'>
        {title}
      </h1>
      {children}
    </section>
  );
};

export default StatisticsLayout;
