import clsx from 'clsx';
import type { FC, FormEvent, ReactNode } from 'react';

interface StatisticsFiltersFormProps {
  className?: string;
  onSubmit?: () => void;
  children: ReactNode;
}

const StatisticsFiltersForm: FC<StatisticsFiltersFormProps> = ({
  children,
  className,
  onSubmit,
}) => {
  const handleSubmit = (event: FormEvent) => {
    event.preventDefault();
    onSubmit?.();
  };

  return (
    <form
      onSubmit={handleSubmit}
      className={clsx('mt-6 mb-10 max-w-[70%] w-full flex flex-wrap gap-[20px]', className)}
    >
      {children}
    </form>
  );
};

export default StatisticsFiltersForm;
