import { useState, type FC, type ReactNode } from 'react';
import { Select } from '@/components/UI/Select';
import { exportFormatOptions } from '@/pagesComponents/Statistics/constants';

const StatisticsFilterWrapper: FC<{ children: ReactNode }> = ({ children }) => {
  const [exportFormatValue, setExportFormatValue] = useState<string>('');
  return (
    <section className='mt-6'>
      <div className='flex justify-between'>
        {children}
        <Select
          label='Формат экспорта:'
          options={exportFormatOptions}
          placeholder='PDF'
          classes={{ root: 'max-w-[190px] mt-6' }}
          value={exportFormatValue}
          onChange={(value) => setExportFormatValue(value as string)}
        />
      </div>
    </section>
  );
};

export default StatisticsFilterWrapper;
