'use client';
import dynamic from 'next/dynamic';
import clsx from 'clsx';
import { type FC, type ReactNode, useState } from 'react';
import Icon from '@/components/Icon';
const Modal = dynamic(() => import('@/components/UI/Modal'), { ssr: false });
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransport';
import type { ModalProps } from '@/components/UI/Modal';

interface ChoosingTransportProps extends Omit<ModalProps, 'isOpen' | 'closeModal' | 'children'> {
  className?: string;
  placeholder?: string;
  label?: string | ReactNode;
}

const ChoosingTransportWrapper: FC<ChoosingTransportProps> = ({
  className,
  label,
  placeholder,
  ...rest
}) => {
  const [isOpenModal, setIsOpenModal] = useState<boolean>(false);

  return (
    <>
      <div className={clsx('w-full', className)}>
        {label && <p className='text-base leading-4 mb-1'>{label}</p>}
        <div
          className='h-[56px] px-4 flex items-center justify-between gap-1 border border-light_gray bg-white rounded-xl'
          role='button'
          onClick={() => setIsOpenModal(true)}
        >
          <p className='whitespace-nowrap overflow-hidden text-ellipsis text-[#A6A6A6] text-[14px] leading-[14px]'>
            {placeholder}
          </p>
          <Icon src='/images/icons/icon-ellipsis.svg' className='size-6 text-primary' />
        </div>
      </div>
      <Modal
        isOpen={isOpenModal}
        closeModal={() => setIsOpenModal(false)}
        title={rest.title || 'Выбор транспорта'}
        headerClassName='bg-[#15223C]'
        {...rest}
      >
        <ChoosingTransport onClose={() => setIsOpenModal(false)} />
      </Modal>
    </>
  );
};

export default ChoosingTransportWrapper;
