import type { FC } from 'react';
import Icon from '@/components/Icon';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import Table, {
  type TableProps,
  type TableData,
  type TableDataColumn,
} from '@/components/UI/Table';
import { Checkbox } from '@/components/UI/Checkbox';
import { Button } from '@/components/UI/Button';

const headHeadings = [
  {
    name: <Checkbox isActive value='ALL' wrapperClassName='justify-center' />,
    key: 'ALL',
    renderColumn: (column: TableDataColumn, _rowData: TableData) => (
      <Checkbox isActive value={column?.toString() || ''} wrapperClassName='justify-center' />
    ),
  },
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Компания', key: 'company' },
  { name: 'Автоколонна', key: 'convoy' },
  {
    name: 'Операции',
    key: 'operations',
    renderColumn: (column: TableDataColumn, _rowData: TableData) => (
      <button type='button'>
        <Icon
          src='/images/icons/icon-search.svg'
          className='size-[21px] min-w-[21px] text-primary mr-4'
        />
      </button>
    ),
  },
];

interface ChoosingTransportProps extends Omit<TableProps, 'className' | 'headHeadings'> {
  onClose?: () => void;
  onSave?: () => void;
  onAllChoose?: () => void;
}

const ChoosingTransport: FC<ChoosingTransportProps> = ({
  onAllChoose,
  onClose,
  onSave,
  ...rest
}) => {
  return (
    <div>
      <div className='flex items-center gap-4'>
        <Select placeholder='Выбор компании/Автоколонна' />
        <Select placeholder='Все типы' />
        <Input
          placeholder='Найти транспорт'
          wrapperInputClassName='h-[56px]'
          icon={
            <Icon
              src='/images/icons/icon-search.svg'
              className='size-[21px] min-w-[21px] text-primary mr-4'
            />
          }
        />
      </div>

      <Table className='mt-4 mb-10' headHeadings={headHeadings} {...rest} />

      <div className='flex items-center gap-4 justify-center'>
        <Button variant='gray_outlined' className='max-w-max' onClick={onClose}>
          Закрыть
        </Button>
        <Button variant='gray_outlined' className='max-w-max' onClick={onAllChoose}>
          Выбрать все
        </Button>
        <Button className='max-w-max' onClick={onSave}>
          Сохранить
        </Button>
      </div>
    </div>
  );
};

export default ChoosingTransport;
