'use client';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import DeviceReport from './DeviceReport';
import Main from './Main';
import MileageMonitoring from './MileageMonitoring';
import NumberOfViolations from './NumberOfViolations';

const widgets = {
  '': {
    title: 'Подробный отчёт',
    component: <Main />,
  },
  numberOfViolations: {
    title: 'Количество нарушений',
    component: <NumberOfViolations />,
  },
  mileage_monitoring: {
    title: 'Мониторинг пробега',
    component: <MileageMonitoring />,
  },
  device_report: {
    title: 'Отчёт об устройстве',
    component: <DeviceReport />,
  },
};

const ViolationRules = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';
  const { widget } = useDeterminateWidget({ activeWidget, redirectLink: '/statistics', widgets });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default ViolationRules;
