'use client';
import { useState } from 'react';
import Tabs from '@/components/Tabs';
import { ITab } from '@/components/Tabs/Tabs';
import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import { Container } from '@/components/UI/Container';
import Table from '@/components/UI/Table';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import type { IOption } from '@/types/IOption';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const tabs: ITab[] = [
  { key: 'violations', title: 'Нарушения' },
  { key: 'statistics', title: 'Статистика' },
];

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Компания', key: 'company' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'ending' },
  { name: 'Overspeed alarm', key: 'overspeed' },
  { name: 'Period Overspeed Alarm(Platform)', key: 'overspeed_alarm' },
  { name: 'Period of Low Speed Alarm(Platform)', key: 'low_speed_period' },
  { name: 'Overtime Parking(Platform)', key: 'overtime_parking' },
  { name: 'Fatigue Driving (Platform)', key: 'fatique_driving' },
  { name: 'Early Morning Operation(Platform)', key: 'early_morning_operation' },
  { name: 'Время вождения за день превышено', key: 'time_driving_upper_for_day' },
  { name: 'Road Class Overspeed Alarm(Platform)', key: 'road_class_overspeed_alarm' },
  { name: 'Rapid Acceleration', key: 'rapid_acceleration' },
  { name: 'Rapid Deceleration', key: 'rapid_deceleration' },
  { name: 'Night Overspeed', key: 'night_overspeed' },
  { name: 'Fatigue at the wheel', key: 'fatique_at_wheel' },
  { name: 'Road Level Speeding', key: 'road_level_speeding' },
  { name: 'Over Speed Warning', key: 'overspeed_warning' },
  { name: 'Fatigue Driving Warning', key: 'fatique_driving_warning' },
];

const alarmTypeOptions: IOption[] = [
  { label: 'Итоговый отчет', value: 'result_report' },
  { label: 'Ежедневный отчет', value: 'daily_report' },
  { label: 'Ежемесячный отчет', value: 'monthly_report' },
];

const transportRequestOptions: IOption[] = [
  { label: 'Запрос транспорта', value: 'transport_request' },
  { label: 'Запрос группы', value: 'transport_group' },
];

const NumberOfViolations = () => {
  const [activeTab, setActiveTab] = useState<string>(tabs[0].key);
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Структура:'
            placeholder='Запрос транспорта'
            classes={{ root: 'max-w-[320px]' }}
            options={transportRequestOptions}
          />
          <Select
            label='Тип тревоги:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={alarmTypeOptions}
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <Container>
        <section className='py-6 flex justify-center border-t-[1px] border-light_gray mt-10'>
          <Tabs tabs={tabs} value={activeTab} onChange={(value) => setActiveTab(value)} />
        </section>
      </Container>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};
export default NumberOfViolations;
