import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import { Button } from '@/components/UI/Button';
import Table from '@/components/UI/Table';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import {
  choiceTimeOptions,
  proccesingStatusOptions,
  processingMethod,
  alarmTypeOptions,
} from '@/pagesComponents/Statistics/constants';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Компания', key: 'company' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'ending' },
  { name: 'Количество остановок', key: 'stops_number' },
  { name: 'Общее время остановок', key: 'total_stops_number' },
  { name: 'Общее время простоя', key: 'total_downtime' },
  { name: 'Общее время', key: 'total_time' },
];

const Main = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Тип тревоги:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={alarmTypeOptions}
          />
          <Input
            label='Длительность тревог:'
            placeholder='в секундах'
            className='max-w-[320px]'
            wrapperInputClassName='h-[56px]'
          />
          <Select
            label='Статус обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={proccesingStatusOptions}
          />
          <Select
            label='Способ обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={processingMethod}
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default Main;
