'use client';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import Main from './Main';
import TransportStopsWidget from './TransportStops';
import NumberOfIgnitionSwitches from './NumberOfIgnitionSwitches';
import DetailedReport from './DetailedReport';
import AccIgnitionDayStatistics from './AccIgnitionDayStatistics';

const widgets = {
  '': {
    title: 'Количество остановок',
    component: <Main />,
  },
  transportStops: {
    title: 'Остановки',
    component: <TransportStopsWidget />,
  },
  numberOfIgnitionSwitches: {
    title: 'Количество включений зажигания',
    component: <NumberOfIgnitionSwitches />,
  },
  detailedReport: {
    title: 'Подробный отчет',
    component: <DetailedReport />,
  },
  accIgnitionDayStatistics: {
    title: 'ACC ignition day statistics',
    component: <AccIgnitionDayStatistics />,
  },
};

const TransportStops = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/transport_stops',
    widgets,
  });
  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default TransportStops;
