import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import type { IOption } from '@/types/IOption';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Компания', key: 'company' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Тип тревоги', key: 'alarm_type' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'ending' },
  { name: 'Длительность', key: 'duration' },
  { name: 'Место остановки', key: 'stop_place' },
];

const alarmTypeOptions: IOption[] = [
  { label: 'Все', value: 'ALL' },
  { label: 'Стоит', value: 'worth' },
  { label: 'Припаркован', value: 'parking' },
];

const TransportStops = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Тип тревоги:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={alarmTypeOptions}
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default TransportStops;
