'use client';
import Link from 'next/link';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import Main from './Main';
import SummarySpeedLimitReport from './SummarySpeedLimitReport';
import IdRptIdentificationCard from './IdRptIdentificationCard';

const widgets = {
  '': {
    title: 'Порог превышения скорости',
    component: <Main />,
  },
  summarySpeedLimitReport: {
    title: 'Сводный порог превышения скорости отчёт',
    component: <SummarySpeedLimitReport />,
  },
  idRptIdentificationCard: {
    title: 'Идентификационная карта ID RPT',
    component: <IdRptIdentificationCard />,
  },
};

const ThresholdSpeedLimit = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/transport_stops',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default ThresholdSpeedLimit;
