import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Водитель', key: 'driver' },
  { name: 'Компания', key: 'company' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'ending' },
  { name: 'Продолжительность работы', key: 'work_duration' },
  { name: 'Начальная скорость', key: 'start_speed' },
  { name: 'Конечная скорость', key: 'end_speed' },
  { name: 'Начальное положение', key: 'start_place' },
  { name: 'Конечное местоположение', key: 'end_place' },
  { name: 'Swipe info', key: 'swipe_info' },
];

const SummarySpeedLimitReport = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default SummarySpeedLimitReport;
