'use client';
import Link from 'next/link';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import TemperatureChange from './TemperatureChange';
import OverheatingReport from './OverheatingReport';
import Main from './Main';

const widgets = {
  '': {
    title: 'Количество тревог',
    component: <Main />,
  },
  temperature_change: {
    title: 'Изменение температуры',
    component: <TemperatureChange />,
  },
  overheating_report: {
    title: 'Отчет о перегревах',
    component: <OverheatingReport />,
  },
};

const Temperature = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/temperature',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default Temperature;
