import { Button } from '@/components/UI/Button';
import { Container } from '@/components/UI/Container';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions, imagesTypeOptions } from '@/pagesComponents/Statistics/constants';
import type { IOption } from '@/types/IOption';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Компания', key: 'company' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Время', key: 'time' },
  { name: 'Текущая температура', key: 'temperature' },
  { name: 'Пробег', key: 'mileage' },
  { name: 'Координаты', key: 'coordinates' },
];

const timeIntervalOptions: IOption[] = [
  { label: '0 Секунд', value: '0_sec' },
  { label: '120Секунды', value: '120_sec' },
  { label: '180Секунды', value: '180_sec' },
  { label: '240Секунды', value: '240_sec' },
  { label: '300Секунды', value: '300_sec' },
  { label: '600Секунды', value: '600_sec' },
  { label: '1200Секунды', value: '1200_sec' },
  { label: '1800Секунды', value: '1800_sec' },
];

const TemperatureChange = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Временной интервал:'
            placeholder='0(км)'
            classes={{ root: 'max-w-[320px]' }}
            options={timeIntervalOptions}
          />
          <Input
            label='укажите температуру от'
            placeholder='Все'
            className='max-w-[320px]'
            wrapperInputClassName='h-[56px]'
          />
          <Select
            label='Тип изображения:'
            placeholder='PNG'
            classes={{ root: 'max-w-[320px]' }}
            options={imagesTypeOptions}
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <Container>
        <div className='px-4 py-6 bg-white border border-[#E6E9EE] rounded-lg'>
          <p className='text-[28px] leading-9 font-medium'>Температурный профиль</p>
        </div>
      </Container>

      <TableWrapper className='mt-10'>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default TemperatureChange;
