'use client';
import Link from 'next/link';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import Main from './Main';
import DetailedInformationReleased from './DetailedInformationReleased';
import DriverRecord from './DriverRecord';
import FaultReport from './FaultReport';

const widgets = {
  '': {
    title: 'Запрошенные отчеты',
    component: <Main />,
  },
  detailed_info_rpt: {
    title: 'Подробная выпущенная информация RPT',
    component: <DetailedInformationReleased />,
  },
  driver_info_rpt: {
    title: 'Запись водителя RPT',
    component: <DriverRecord />,
  },
  faultReport: {
    title: 'Отчет о неисправностях',
    component: <FaultReport />,
  },
};

const ReportRequests = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/report_requests',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default ReportRequests;
