'use client';
import Link from 'next/link';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import Main from './Main';
import TotalPassengerStatistics from './TotalPassengerStatistics';
import SummaryPassengerStatistics from './SummaryPassengerStatistics';
import RequestForPassengerStatistics from './RequestForPassengerStatistics';

const widgets = {
  '': {
    title: 'Детальная статистика пассажиров',
    component: <Main />,
  },
  total_passenger_statistics: {
    title: 'Суммарная статистика пассажиров',
    component: <TotalPassengerStatistics />,
  },
  summary_passenger_statistics: {
    title: 'Сводная статистика пассажиров',
    component: <SummaryPassengerStatistics />,
  },
  request_for_passenger_statistics: {
    title: 'Запрос статистики пассажиров',
    component: <RequestForPassengerStatistics />,
  },
};

const PassengerStatisticsReport = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/passenger_statistics_report',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default PassengerStatisticsReport;
