import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Компания', key: 'company' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Компания', key: 'company' },
  { name: 'Время', key: 'time' },
  { name: 'Координаты', key: 'coordinates' },
  { name: 'Номер на двери машины', key: 'number_on_door' },
  { name: 'Номер входной двери выключен', key: 'number_open_door_is_turned_off' },
  { name: 'Middle Boarding', key: 'middle_boarding' },
  { name: 'Средний выходящий', key: 'average_output' },
  { name: 'Номер машины на задней двери', key: 'number_on_back_door' },
  { name: 'Число задних дверей', key: 'back_door_count' },
  { name: 'Количество пассажиров', key: 'passenger_count' },
  { name: 'Дополнительный персонал', key: 'additional_personal' },
];

const RequestForPassengerStatistics = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default RequestForPassengerStatistics;
