'use client';
import Link from 'next/link';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import Main from './Main';
import DetailedReport from './DetailedReport';
import ShortDescriptionUserActions from './ShortDescriptionUserActions';
import UserInformation from './UserInformation';
import UserMediaSummary from './UserMediaSummary';
import CarMaintenanceRecords from './CarMaintenanceRecords';
import DeviceChangeRpt from './DeviceChangeRpt';
import MailPushRecord from './MailPushRecord';

const widgets = {
  '': {
    title: 'Количество подключений и отключений',
    component: <Main />,
  },
  detailed_report: {
    title: 'Подробный отчёт',
    component: <DetailedReport />,
  },
  usersLog: {
    title: 'Журнал пользователя',
    component: <DetailedReport />,
  },
  shortDescriptionUserActions: {
    title: 'Краткое описание действий пользователя',
    component: <ShortDescriptionUserActions />,
  },
  userInformation: {
    title: 'Сведения о пользователе',
    component: <UserInformation />,
  },
  userMediaSummary: {
    title: 'User Media Summary',
    component: <UserMediaSummary />,
  },
  carMaintenanceRecords: {
    title: 'Car Maintenance Records',
    component: <CarMaintenanceRecords />,
  },
  deviceChangeRpt: {
    title: 'Device Change RPT',
    component: <DeviceChangeRpt />,
  },
  mailPushRecord: {
    title: 'Mail Push Record',
    component: <MailPushRecord />,
  },
};

const NetworkConnecting = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/network_connecting',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default NetworkConnecting;
