import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Аккаунт', key: 'account' },
  { name: 'Имя', key: 'name' },
  { name: 'Компания', key: 'company' },
  { name: 'Тип тревоги', key: 'alarm_type' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Номер устройства', key: 'device_number' },
  { name: 'Время', key: 'time' },
  { name: 'Описание', key: 'description' },
];

const UsersLog = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <Select label='Пользователь:' placeholder='Все' classes={{ root: 'max-w-[320px]' }} />
          <Select label='Тип запроса:' placeholder='Все' classes={{ root: 'max-w-[320px]' }} />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default UsersLog;
