import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import type { IOption } from '@/types/IOption';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Аккаунт', key: 'account' },
  { name: 'Имя', key: 'name' },
  { name: 'Компания', key: 'company' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'end' },
  { name: 'Длительность', key: 'duration' },
  { name: 'Статистика сетевого трафика', key: 'network_trafic_statistics' },
];

const userTypeOptions: IOption[] = [
  { label: 'Vehicle', value: 'vehicle' },
  { label: 'Пользователь', value: 'user' },
];

const UserMediaSummary = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <Select
            label='Тип пользователя:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={userTypeOptions}
          />
          <Select label='Пользователь:' placeholder='Все' classes={{ root: 'max-w-[320px]' }} />
          <Select label='Тип запроса:' placeholder='Все' classes={{ root: 'max-w-[320px]' }} />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default UserMediaSummary;
