import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import { Input } from '@/components/UI/Input';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Вход в аккаунт', key: 'enter_account' },
  { name: 'Имя', key: 'name' },
  { name: 'Компания', key: 'company' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'end' },
  { name: 'Количество тревог', key: 'alarm_count' },
];

const ShortDescriptionUserActions = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <Select label='Пользователь:' placeholder='Все' classes={{ root: 'max-w-[320px]' }} />
          <Input
            label='Активное время'
            placeholder='Все'
            className='max-w-[320px]'
            wrapperInputClassName='h-[56px]'
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default ShortDescriptionUserActions;
