import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import type { IOption } from '@/types/IOption';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Номер устройства', key: 'device_id' },
  { name: 'Компания', key: 'company' },
  { name: 'Транспортное средство', key: 'transport' },
  { name: 'Change Content', key: 'change_content' },
  { name: 'Change Time', key: 'change_time' },
  { name: 'Change Account', key: 'change_account' },
  { name: 'Change Person', key: 'change_person' },
  { name: 'Change Detail', key: 'change_detail' },
];

const sendStatusOptions: IOption[] = [
  { label: 'Да', value: 'yes' },
  { label: 'Нет', value: 'no' },
];

const MailPushRecord = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>

          <Select label='Пользователь:' placeholder='Все' classes={{ root: 'max-w-[320px]' }} />
          <Select
            label='Статус отправки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={sendStatusOptions}
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default MailPushRecord;
