import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Аккаунт', key: 'account' },
  { name: 'Имя', key: 'name' },
  { name: 'Компания', key: 'company' },
  { name: 'Информация о пользователе', key: 'user_info' },
  { name: 'Логин IP', key: 'ip_login' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'end' },
  { name: 'Длительность', key: 'duration' },
  { name: 'Примечание', key: 'note' },
];

const DetailedReport = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <Select label='Пользователь:' placeholder='Все' classes={{ root: 'max-w-[320px]' }} />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default DetailedReport;
