'use client';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import Main from './Main';
import Audio from './Audio';
import Video from './Video';

const widgets = {
  '': {
    title: 'Фото (новые)',
    component: <Main />,
  },
  audio: {
    title: 'Аудио (новые)',
    component: <Audio />,
  },
  video: {
    title: 'Видео (новые)',
    component: <Video />,
  },
};

const Multimedia = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/multimedia',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default Multimedia;
