import { ReactNode, type FC } from 'react';
import clsx from 'clsx';
import Image from 'next/image';
import Icon from '@/components/Icon';

interface MultimediaImageProps {
  src?: string;
  className?: string;
  iconWrapperClassName?: string;
  alt?: string;
  children?: ReactNode;
}

const MultimediaImage: FC<MultimediaImageProps> = ({
  className,
  src,
  iconWrapperClassName,
  alt,
  children,
}) => {
  return (
    <div className={clsx('border border-light_gray bg-white rounded-lg', className)}>
      <div className={clsx('p-9 flex justify-center items-center', iconWrapperClassName)}>
        {src ? (
          <Image src={src} alt={alt || 'image'} width={140} height={140} />
        ) : (
          <Icon src='/images/icons/icon-image.svg' className='w-[140px] h-[140px]' />
        )}
      </div>
      {children}
    </div>
  );
};

export default MultimediaImage;
