import clsx from 'clsx';
import { FC } from 'react';
import Icon from '@/components/Icon';

interface AudioItemProps {
  fileName: string;
  className?: string;
}

const AudioItem: FC<AudioItemProps> = ({ fileName, className }) => {
  return (
    <div className={clsx('rounded-2xl p-4 flex items-center justify-between gap-[20%]', className)}>
      <p className='text-base leading-4 w-max min-w-max'>{fileName}</p>

      <div className='flex items-center w-full'>
        <button title='Начать просмотр' arial-label='Начать просмотр' className='mr-[19px]'>
          <Icon src='/images/icons/icon-start-video.svg' className='w-6 h-6 text-primary' />
        </button>
        <button title='Пауза' arial-label='Пауза' className='mr-[19px]'>
          <Icon src='/images/icons/icon-pause-video.svg' className='w-6 h-6 text-[#D6D7DB]' />
        </button>
        <button title='Перемотать' arial-label='Перемотать' className='mr-[19px]'>
          <Icon src='/images/icons/icon-rewind.svg' className='w-6 h-6 text-[#D6D7DB]' />
        </button>

        <div className='flex items-center gap-[14px]'>
          <button>
            <Icon
              src='/images/icons/icon-minus-video-speed.svg'
              className='w-6 h-6 text-[#D6D7DB]'
            />
          </button>
          <p>1x</p>
          <button>
            <Icon
              src='/images/icons/icon-plus-video-speed.svg'
              className='w-6 h-6 text-[#D6D7DB]'
            />
          </button>
        </div>

        <div className='relative h-2 rounded-[3px] bg-[#0A0A0A0A] w-full mr-[27px] ml-[32px] after:w-[40%] after:bg-primary after:h-2 after:rounded-[3px] after:block'>
          <span className='absolute top-[-6px] left-[calc(40%-10px)] size-5 rounded-[50%] bg-white border-4 border-primary' />
        </div>

        <time className='text-text text-base font-medium'>00:00:00/00:00:00</time>
      </div>
    </div>
  );
};

export default AudioItem;
