import { Button } from '@/components/UI/Button';
import { Container } from '@/components/UI/Container';
import { Select } from '@/components/UI/Select';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import MultimediaImage from '@/pagesComponents/Statistics/Multimedia/components/MultimediaImage';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import { statusOptions } from '@/pagesComponents/Statistics/Multimedia/constants';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const imagesArray = new Array(16).fill('');

const Video = () => {
  return (
    <Container>
      <div className='flex justify-between gap-4 mt-6'>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Статус:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={statusOptions}
          />
        </StatisticsFiltersForm>
        <Button className='min-w-[190px] max-w-[190px] mt-[48px]' variant='secondary'>
          Экспортировать Zip
        </Button>
      </div>

      <div className='grid grid-cols-5 gap-5 mt-10'>
        {imagesArray.map((_, index) => (
          <MultimediaImage key={index} iconWrapperClassName='bg-[#D9D9D9]'>
            <div className='p-4'>
              <p className='text-base leading-4'>CH1 2024-05-02 11:49:40</p>
              <p className='text-sm leading-[14px] text-[#E31717] mt-2 mb-3'>Приближении сзади</p>
              <Button className='max-w-[120px]' variant='secondary'>
                Скачать
              </Button>
            </div>
          </MultimediaImage>
        ))}
      </div>
    </Container>
  );
};

export default Video;
