import { Button } from '@/components/UI/Button';
import { Container } from '@/components/UI/Container';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import MultimediaImage from '@/pagesComponents/Statistics/Multimedia/components/MultimediaImage';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import { typeChoiceOptions, choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import type { IOption } from '@/types/IOption';
import { statusOptions } from '@/pagesComponents/Statistics/Multimedia/constants';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Количество фото', key: 'photo_count' },
];

const channelOptions: IOption[] = [
  { label: 'Все', value: 'ALL' },
  ...new Array(16).fill('').map((_, index) => {
    return {
      label: `CH${index + 1}`,
      value: `ch-${index + 1}`,
    };
  }),
];

const imagesArray = new Array(20).fill('');

const Main = () => {
  return (
    <Container>
      <div className='flex justify-between gap-4 mt-6'>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Статус обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={statusOptions}
          />
          <div className='flex items-end w-full max-w-[320px]'>
            <Select
              label='Канал:'
              placeholder='Все'
              classes={{ root: 'max-w-[160px]' }}
              options={channelOptions}
            />
            <Select placeholder='Все' classes={{ root: 'max-w-[160px]' }} />
          </div>
          <div className='flex items-end'>
            <Select
              label='Выбор типа:'
              placeholder='Номер задания'
              classes={{ root: 'max-w-[170px]' }}
              options={typeChoiceOptions}
            />
            <Input
              placeholder='Чёткий запрос'
              className='max-w-[170px]'
              wrapperInputClassName='h-[56px]'
            />
          </div>
        </StatisticsFiltersForm>

        <Button className='min-w-[190px] max-w-[190px] mt-[48px]' variant='secondary'>
          Экспортировать Zip
        </Button>
      </div>

      <section className='mt-10 flex justify-between gap-5'>
        <div className='border border-light_gray bg-white p-4 h-full rounded-lg min-w-[660px]'>
          <Table headHeadings={headHeadings} />
        </div>
        <div className='flex flex-wrap gap-5 items-center'>
          {imagesArray.map((_, index) => (
            <MultimediaImage key={index} />
          ))}
        </div>
      </section>
    </Container>
  );
};

export default Main;
