import { Button } from '@/components/UI/Button';
import { Container } from '@/components/UI/Container';
import { Select } from '@/components/UI/Select';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import AudioItem from '@/pagesComponents/Statistics/Multimedia/components/AudioItem';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import { statusOptions } from '@/pagesComponents/Statistics/Multimedia/constants';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const filesArray = new Array(10).fill('');

const Audio = () => {
  return (
    <Container>
      <div className='flex justify-between gap-4 mt-6'>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Статус:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={statusOptions}
          />
        </StatisticsFiltersForm>

        <Button className='min-w-[190px] max-w-[190px] mt-[48px]' variant='secondary'>
          Экспортировать Zip
        </Button>
      </div>

      <section className='mt-10'>
        {filesArray.map((_, index) => (
          <AudioItem
            key={index}
            fileName='Название файла'
            className='bg-white [&:nth-child(2n)]:bg-[#F0F0F0]'
          />
        ))}
      </section>
    </Container>
  );
};

export default Audio;
