import Icon from '@/components/Icon';
import { Button } from '@/components/UI/Button';
import { Input } from '@/components/UI/Input';
import Table from '@/components/UI/Table';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Водитель', key: 'driver' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Тип транспорта', key: 'transport_type' },
  { name: 'Компания', key: 'company' },
  { name: 'Общая дистанция', key: 'total_distance' },
  ...new Array(31).fill('').map((_, index) => {
    return {
      name: `${index + 1} (км)`,
      key: `${index + 1}_km`,
    };
  }),
];

const MileageMonthly = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Input
            label='Выбор месяца:'
            placeholder='2024-06'
            icon={<Icon src='/images/icons/icon-calendar.svg' className='w-6 h-6 mr-4' />}
            className='max-w-[320px]'
          />
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default MileageMonthly;
