import { Button } from '@/components/UI/Button';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import { headHeadings } from '@/pagesComponents/Statistics/Mileage/constants';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import type { IOption } from '@/types/IOption';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const alarmTypeOptions: IOption[] = [
  { label: 'Ежедневный отчет', value: 'daily_report' },
  { label: 'Ежемесячный отчет', value: 'monthly_report' },
];

const MileageByTime = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Тип тревоги:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={alarmTypeOptions}
          />
          <Input
            label='Ежедневный пробег (>=):'
            placeholder='КМ'
            className='max-w-[320px]'
            wrapperInputClassName='h-[56px]'
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default MileageByTime;
