import { Button } from '@/components/UI/Button';
import { Container } from '@/components/UI/Container';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import { headHeadings } from '@/pagesComponents/Statistics/Mileage/constants';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import { exportFormatOptions } from '@/pagesComponents/Statistics/constants';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';

const MileageMain = () => {
  return (
    <>
      <div className='flex justify-between gap-4 mt-6'>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Input
            label='Ежедневный пробег (>=):'
            placeholder='КМ'
            className='max-w-[320px]'
            wrapperInputClassName='h-[56px]'
          />
        </StatisticsFiltersForm>

        <div className='flex gap-4 items-end h-full mt-4'>
          <Select
            label='Формат экспорта:'
            options={exportFormatOptions}
            placeholder='PDF'
            classes={{ root: 'w-[190px]' }}
          />
          <Button className='min-w-[190px] max-w-[190px]' variant='secondary'>
            Настройка импорта
          </Button>
        </div>
      </div>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default MileageMain;
