'use client';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import Main from './Main';
import DetailedReport from './DetailedReport';
import DetailInfoAboutAreas from './DetailInfoAboutAreas';

const widgets = {
  '': {
    title: 'Общий отчет о геозонах',
    component: <Main />,
  },
  detailed_report: {
    title: 'Подробный отчёт',
    component: <DetailedReport />,
  },
  detail_info_about_areas: {
    title: 'Подробная информация о зоне въезда и выезда',
    component: <DetailInfoAboutAreas />,
  },
};

const Geofences = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/geofences',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default Geofences;
