import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import { headHeadings } from '@/pagesComponents/Statistics/Geofences/constants';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import {
  choiceTimeOptions,
  proccesingStatusOptions,
  processingMethod,
} from '@/pagesComponents/Statistics/constants';
import type { IOption } from '@/types/IOption';
import { Input } from '@/components/UI/Input';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const zoneOptions: IOption[] = [
  { label: 'Все', value: 'ALL' },
  { label: 'Тест', value: 'test' },
  { label: 'Зона 1', value: 'zone_1' },
];

const alarmTypeOptions: IOption[] = [
  { label: 'Все', value: 'ALL' },
  { label: 'Cross-border Alarm', value: 'cross_border_alarm' },
  { label: 'Regional Speeding Alarm', value: 'regional_speed_alarm' },
  { label: 'Out of Area Alarm', value: 'out_of_area_alarm' },
  { label: 'Out of Line', value: 'out_of_line' },
  { label: 'Roads and The Lack of Time or Too Long', value: 'roads_lack_time' },
  { label: 'Route Deviation', value: 'route_deviation' },
  { label: 'Regional Speeding Alarm(Platform)', value: 'regional_speed_alarm' },
  { label: 'Regional Low Speed Alarm(Platform)', value: 'regional_low_speed_alarm' },
  { label: 'Entry and Exit Area(Platform)', value: 'entry_exit_area' },
  { label: 'Line Offset(Platform)', value: 'line_offset' },
  { label: 'The Key Point Monitoring Alarm(Platform)', value: 'key_point_monitoring' },
  { label: 'Line Overspeed Alarm(Platform)', value: 'line_overspeed' },
  { label: 'Line Low Overspeed Alarm(Platform)', value: 'line_low_overspeed' },
  { label: 'Area Overtime Parking (platform)', value: 'area_overtime_parking' },
];

const DetailedReport = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Тип тревоги:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={alarmTypeOptions}
          />
          <Input
            label='Длительность тревоги:'
            placeholder='В секундах'
            className='max-w-[320px]'
            wrapperInputClassName='h-[56px]'
          />
          <Select
            label='Статус обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={proccesingStatusOptions}
          />
          <Select
            label='Способ обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={processingMethod}
          />
          <Select
            label='Название зоны:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={zoneOptions}
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default DetailedReport;
