import { Button } from '@/components/UI/Button';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import type { IOption } from '@/types/IOption';
import { proccesingStatusOptions, processingMethod } from '@/pagesComponents/Statistics/constants';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Компания', key: 'company' },
  { name: 'Название зоны', key: 'zone_name' },
  { name: 'Время въезда в геозону', key: 'time_of_entry_into_the_geofence' },
  { name: 'Время выезда из геозоны', key: 'time_of_departure_from_the_geofence' },
  { name: 'Время нахождения в геозоне', key: 'time_spent_in_the_geofence' },
];

const alarmTypeOptions: IOption[] = [
  { label: 'Entry and Exit Area(Platform)', value: 'entry_exit_area' },
];

const zoneOptions: IOption[] = [
  { label: 'Все', value: 'ALL' },
  { label: 'Тест', value: 'test' },
  { label: 'Зона 1', value: 'zone_1' },
];

const DetailInfoAboutAreas = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Тип тревоги:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={alarmTypeOptions}
          />
          <Input
            label='Время нахождения в геозоне'
            placeholder='в секундах'
            className='w-[320px]'
            wrapperInputClassName='h-[56px]'
          />
          <Select
            label='Статус обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={proccesingStatusOptions}
          />
          <Select
            label='Способ обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={processingMethod}
          />
          <Select
            label='Название зоны:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={zoneOptions}
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default DetailInfoAboutAreas;
