'use client';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import Main from './Main';
import GSensorDetailReport from './GSensorDetailReport';

const widgets = {
  '': {
    title: 'G-Сенсор тревога статистика',
    component: <Main />,
  },
  gSensorDetailReport: {
    title: 'G-Сенсор тревога детально',
    component: <GSensorDetailReport />,
  },
};

const GSensorReport = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/g_sensor_report',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default GSensorReport;
