import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import {
  choiceTimeOptions,
  processingMethod,
  proccesingStatusOptions,
} from '@/pagesComponents/Statistics/constants';
import { Input } from '@/components/UI/Input';
import type { IOption } from '@/types/IOption';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Компания', key: 'company' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Тип тревоги', key: 'alarm_type' },
  { name: 'Источник тревоги', key: 'alarm_source' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'end' },
  { name: 'Длительность тревоги', key: 'alarm_duration' },
  { name: 'Начальная скорость', key: 'start_speed' },
  { name: 'Конечная скорость', key: 'end_speed' },
  { name: 'Информация тревог', key: 'alarm_info' },
  { name: 'Статус отчёта', key: 'report_status' },
  { name: 'Статус обработки', key: 'processing_status' },
  { name: 'Обработавший пользователь', key: 'processed_user' },
  { name: 'Содержание обработки', key: 'processing_content' },
  { name: 'Способ обработки', key: 'processing_method' },
  { name: 'Время обработки', key: 'processing_time' },
];

const alarmTypeOptions: IOption[] = [
  { label: 'Все', value: 'ALL' },
  { label: 'GSensor Start', value: 'g_sensor_start' },
  { label: 'GSensor Stop', value: 'g_sensor_stop' },
  { label: 'Rapid Acceleration', value: 'rapid_acceleration' },
  { label: 'Rapid Deceleration', value: 'rapid_decceleration' },
  { label: 'Sharp Turn', value: 'sharp_turn' },
  { label: 'Collision Rollover Alarm', value: 'collision_rollover_alarm' },
  { label: 'GSensor RollOver', value: 'g_sensor_rollover' },
];

const GSensorDetailReport = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Тип тревоги:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={alarmTypeOptions}
          />
          <Input
            label='Длительность тревог'
            placeholder='Все'
            className='max-w-[320px]'
            wrapperInputClassName='h-[56px]'
          />
          <Select
            label='Статус обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={proccesingStatusOptions}
          />
          <Select
            label='Способ обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={processingMethod}
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default GSensorDetailReport;
