'use client';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import Main from './Main';
import VolumeChange from './VolumeChange';
import SensorAlarms from './SensorAlarms';
import FuelConsumptionChart from './FuelConsumptionChart';
import FuelConsumptionPerMonthDay from './FuelConsumptionPerMonthDay';

const widgets = {
  '': {
    title: 'Общий объем',
    component: <Main />,
  },
  volume_change: {
    title: 'Изменение объема',
    component: <VolumeChange />,
  },
  sensor_alarms: {
    title: 'Тревоги датчика',
    component: <SensorAlarms />,
  },
  fuel_consumption_chart: {
    title: 'График расхода топлива',
    component: <FuelConsumptionChart />,
  },
  fuel_consumption_per_month_day: {
    title: 'Расход топлива День/Месяц',
    component: <FuelConsumptionPerMonthDay />,
  },
};

const Fuel = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/fuel',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default Fuel;
