import clsx from 'clsx';
import { FC } from 'react';

interface FuelGraphicProps {
  title: string;
  indicators: { name: string; bg: string }[];
}

const FuelGraphic: FC<FuelGraphicProps> = ({ indicators, title }) => {
  return (
    <div className='border border-[#E6E9EE] rounded-lg px-4 py-6 bg-white'>
      <div className='flex items-center justify-between'>
        <p className='text-[28px] leading-8 font-medium'>{title}</p>
        <div className='flex items-center gap-6'>
          {indicators.map((indicator) => (
            <div className='flex gap-1 items-center' key={indicator.name}>
              <span className={clsx('size-4 min-w-4 min-h-4 rounded-[50%]', indicator.bg)} />
              <p className='text-dark_gray text-sm leading-[14px]'>{indicator.name}</p>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default FuelGraphic;
